local function CheckOptions(opt, default)
	if EXPOK._data[opt] then
		return EXPOK._data[opt]
	end

	return default
end

local function round(num, decimals)
	decimals = math.pow(10, decimals or 0)
	num = num * decimals

	if num >= 0 then
		 num = math.floor(num + 0.5)
	else
 		num = math.ceil(num - 0.5)
	end

	return num / decimals
end

local function custom_colors_con(value, special)
    local c = {
        pastel_pink = {255, 161, 220},
        purple = {240, 33, 255},
        aqua = {0, 255, 221},
        strawb = {251, 41, 65},
        orange = {255, 85, 0},
        red = {255, 0, 0},
        navy = {56, 63, 255},
        pink = {255, 0, 160},
        lilac = {223, 168, 255},
        black = {0, 0, 0},
        blue_violet = {169, 48, 255},
        white = {255, 255, 255},
        green = {0, 255, 0},
        yellow = {255, 255, 0},
        new_yellow = {255, 243, 138},
    }

    local convert = {
        "pastel_pink",
        "purple",
        "aqua",
        "strawb",
        "orange",
        "red",
        "navy",
        "pink",
        "lilac",
        "black",
        "blue_violet",
        "white",
        "green",
        "yellow",
        "new_yellow",
    }

	if value == 16 then
		return 1,1,1
	end

    if value == 17 then
        local random_key = convert[math.random(#convert)]
        local color = c[random_key]
        return color[1] / 255, color[2] / 255, color[3] / 255
    end

    if not value then
        if not special then
            return c.new_yellow[1] / 255, c.new_yellow[2] / 255, c.new_yellow[3] / 255
        else
            return c.purple[1] / 255, c.purple[2] / 255, c.purple[3] / 255
        end
    end

    return c[convert[value]][1] / 255, c[convert[value]][2] / 255, c[convert[value]][3] / 255
end

local function packColorData(...)
	local r,g,b = custom_colors_con(...)
	return Color(r,g,b)
end

function HUDManager:_force_remove_bonus_modern()
	if self._bonus_exp_text then
		local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_FULLSCREEN_PD2)
		local child_bonus = hud.panel:child("bonus_exp_text")
		if child_bonus and alive(child_bonus) then
			hud.panel:remove(child_bonus)
		end
	end
end

function HUDManager:_cleanup()
	self._total_exp = nil
	self._total_exp_text = nil
	self._exp_gained_text = nil
	self._bonus_exp_text = nil
	self._bonus_exp_gained_total = nil
	self._dummy_txt = nil
	managers.player:_killstreak_manage(true)
end

function HUDManager:_modernized_exp_visuals(killstreak, was_special)
    if EXPOK._data.disable_hud_effects then
        return
    end

    local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_FULLSCREEN_PD2)
    local child_total = hud.panel:child("total_exp_text")
    local child_gained = hud.panel:child("exp_gained_text")
    local child_bonus = hud.panel:child("bonus_exp_text")

	was_special = was_special or managers.player:has_active_temporary_property("bonus_xp_special_killed")

    if child_total and alive(child_total) then
        hud.panel:remove(child_total)
    end

    if child_gained and alive(child_gained) then
        hud.panel:remove(child_gained)
    end

    if was_special and child_bonus and alive(child_bonus) then
        hud.panel:remove(child_bonus)
    end

    local total_exp = (self._total_exp or 0)
    local exp_gained = round(managers.player:_exp_gain_manage(true), 1)
    self._total_exp = total_exp + exp_gained

    local function make_fine_text(text)
        local x, y, w, h = text:text_rect()
        text:set_size(w, h)
        text:set_position(math.round(text:x()), math.round(text:y()))
    end

    self._total_exp_text = hud.panel:text({
        name = "total_exp_text",
        y = hud.panel:h() / 2 - 50,
        font_size = EXPOK._data.exp_font_size * 1.2,
        vertical = "center",
        align = "center",
        h = 50,
        w = hud.panel:w(),
        font = "fonts/font_medium_shadow_mf",
		render_template = "OverlayVertexColorTextured",
        text = tostring(total_exp),
        color = packColorData(CheckOptions("exp_color", 14)),
    })

    self._exp_gained_text = hud.panel:text({
        name = "exp_gained_text",
        y = hud.panel:h() / 2 - 30,
        font_size = EXPOK._data.exp_font_size,
        vertical = "center",
        align = "center",
        h = 40,
        w = hud.panel:w(),
		render_template = "OverlayVertexColorTextured",
        font = "fonts/font_medium_shadow_mf",
        text = "+" .. tostring(exp_gained),
        color = packColorData(CheckOptions("exp_color", 2)),
    })

    if was_special then
        local bonus_exp = (exp_gained * 1.2) - exp_gained
		self._bonus_exp_gained_total = (self._bonus_exp_gained_total or 0) + bonus_exp
        self._bonus_exp_text = hud.panel:text({
            name = "bonus_exp_text",
            y = hud.panel:h() / 2,
            font_size = EXPOK._data.exp_font_size,
            vertical = "center",
            align = "center",
            h = 40,
            w = hud.panel:w(),
            font = "fonts/font_medium_shadow_mf",
			render_template = "OverlayVertexColorTextured",
            text = "+" .. tostring(round(bonus_exp, 1)),
            color = packColorData(CheckOptions("specialkilled_color", 2)),
        })

        make_fine_text(self._bonus_exp_text)
		local base_w_bonus = hud.panel:w() / 2 + 25
		local base_h_bonus = hud.panel:h() / 2 + 40
        self._bonus_exp_text:set_center(base_w_bonus + CheckOptions("exp_adjust_x", 0), base_h_bonus + CheckOptions("exp_adjust_y", 0))
    end

    make_fine_text(self._total_exp_text)
    make_fine_text(self._exp_gained_text)

    local total_text = self._total_exp_text
    local gained_text = self._exp_gained_text
    local bonus_text = self._bonus_exp_text
	local base_w_total = hud.panel:w() / 2 + 20
	local base_h_total = hud.panel:h() / 2
	local base_w_gained = hud.panel:w() / 2 + 25
	local base_h_gained = hud.panel:h() / 2 + 20

    total_text:set_center(base_w_total + CheckOptions("exp_adjust_x", 0), base_h_total + CheckOptions("exp_adjust_y", 0))
    gained_text:set_center(base_w_gained + CheckOptions("exp_adjust_x", 0), base_h_gained + CheckOptions("exp_adjust_y", 0))

	local function animate_rainbow_color(text)
		local t = 5
		while true do
			local dt = coroutine.yield()
			t = (t + dt) % 5
			local r, g, b = Color.rainbow()
			text:set_color(Color(r, g, b))
		end
	end

	if CheckOptions("exp_color", 14) == 16 then
		total_text:animate(animate_rainbow_color)
	end

	if CheckOptions("specialkilled_color", 2) == 16 then
		bonus_text:animate(animate_rainbow_color)
	end

	local function create_dummy_text_(c)
		if self._dummy_txt then
			local add = 4

			if c >= 100 then
				add = 8
			end

			self._dummy_txt:set_x(total_text:x() + #tostring(c) + add)

			return
		end
		self._dummy_txt = hud.panel:text({
			name = "total_exp_text_postfix",
			y = hud.panel:h() / 2 - 50,
			font_size = EXPOK._data.exp_font_size * 1.2,
			vertical = "center",
			align = "center",
			h = 50,
			w = hud.panel:w(),
			font = "fonts/font_medium_shadow_mf",
			render_template = "OverlayVertexColorTextured",
			text = " »XP",
			color = packColorData(CheckOptions("exp_color", 14)),
		})

		local add = 4
		if c >= 100 then
			add = 8
		end

		self._dummy_txt:set_x(total_text:x() + #tostring(c) + add)
		self._dummy_txt:set_y(total_text:y())
		make_fine_text(self._dummy_txt)
	end

	local function animate_exp_update()
		local t = 0.5
		local start_exp = total_exp
		local end_exp = self._total_exp + (self._bonus_exp_gained_total or 0)

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 1)
			local current_exp = math.lerp(start_exp, end_exp, 1 - t)
			total_text:set_text(tostring(round(current_exp, 1)))
			create_dummy_text_(current_exp)
			make_fine_text(total_text)
		end

		total_text:set_text(tostring(end_exp) .. " »XP")
		if self._dummy_txt then
			hud.panel:remove(hud.panel:child("total_exp_text_postfix"))
			self._dummy_txt = nil
		end
		make_fine_text(total_text)
	end

    local function animate_gained_text(o)
        local t = 0.8
        while t > 0 do
            local dt = coroutine.yield()
            t = math.clamp(t - dt, 0, 1)
            local alpha = t
            o:set_alpha(alpha)
            o:set_y(o:y() - dt * 60)
        end
        hud.panel:remove(o)
    end

    local function animate_bonus_text(o)
        if not o then return end
        local t = 0.8
        while t > 0 do
			if not alive(o) then
				return
			end
            local dt = coroutine.yield()
            t = math.clamp(t - dt, 0, 1)
            local alpha = t
            o:set_alpha(alpha)
            o:set_y(o:y() - dt * 60)
        end
        hud.panel:remove(o)
    end

    local function fade_out_total_text(o)
        local t = 0.5
        while t > 0 do
            local dt = coroutine.yield()
            t = math.clamp(t - dt, 0, 1)
            local alpha = t
            o:set_alpha(alpha)
            o:set_y(o:y() - dt * 50)
        end
        hud.panel:remove(o)
    end

    total_text:animate(animate_exp_update)
    gained_text:animate(animate_gained_text)

    if was_special then
        bonus_text:animate(animate_bonus_text)
    end

    DelayedCalls:Add("fade_out_total_text", EXPOK._data.kln_duration + 1, function()
        total_text:animate(fade_out_total_text)
		self:_cleanup()
    end)
end


function HUDManager:_kill_exp(killstreak, was_special)
	if EXPOK._data.anim_choice_style == 2 then
		self:_modernized_exp_visuals(killstreak, was_special)
		return
	end

	if EXPOK._data.disable_hud_effects then
		return
	end

	local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_FULLSCREEN_PD2)
	local child = hud.panel:child("exp_text____")
	local child2 = hud.panel:child("killstreak_text__")
	local child_bonus = hud.panel:child("exp_bonus_text____")
	local base_exp = round(managers.player:_exp_gain_manage(true),1)

	self._block_anim = (self._block_anim or false)
	self._previous_num = (self._previous_num or 0)
	self._exp_gained = (self._exp_gained or 0)

	was_special = was_special or managers.player:has_active_temporary_property("bonus_xp_special_killed")

	local killstreak_announce = { "DOUBLE", "TRIPLE", "QUADRA", "PENTA", "HEXA" }
	local shortcut_choice = { " EXP", " »XP" }
	local shrt = shortcut_choice[CheckOptions("shortcut_choice_exp", 2)]

	local function make_fine_text(text)
		local x, y, w, h = text:text_rect()

		text:set_size(w, h)
		text:set_position(math.round(text:x()), math.round(text:y()))
	end

	if was_special then
		self.played_anim_b = false
	end

	if child and alive(child) then
		hud.panel:remove(child)
	end

	if child2 and alive(child2) then
		hud.panel:remove(child2)
	end

	if was_special then
		if child_bonus and alive(child_bonus) then
			hud.panel:remove(child_bonus)
		end
	end

	if was_special then
		self._exp_bonus = hud.panel:text({
			name = "exp_bonus_text____",
			font_size = EXPOK._data.exp_font_size,
			vertical = "center",
			y = hud.panel:h() / 2 - 50,
			h = 50,
			w = hud.panel:w(),
			align = "center",
			render_template = "OverlayVertexColorTextured",
			font = "fonts/font_medium_shadow_mf",
			text = "+0" .. shrt,
			color = packColorData(CheckOptions("specialkilled_color", 2), true)
		})
		make_fine_text(self._exp_bonus)
	end

	self._exp = hud.panel:text({
		name = "exp_text____",
		font_size = EXPOK._data.exp_font_size,
		vertical = "center",
		y = hud.panel:h() / 2 - 50,
		h = 50,
		w = hud.panel:w(),
		align = "center",
		render_template = "OverlayVertexColorTextured",
		font = "fonts/font_medium_shadow_mf",
		text = "+" .. tostring(self._exp_gained) .. shrt,
		color = packColorData(CheckOptions("exp_color", 14))
	})

	self._killstreak_ann = hud.panel:text({
		name = "killstreak_text__",
		font_size = EXPOK._data.kln_font_size,
		vertical = "center",
		align = "center",
		y = hud.panel:h() / 2,
		h = 50,
		w = hud.panel:w(),
		render_template = "OverlayVertexColorTextured",
		font = "fonts/font_medium_shadow_mf",
		text = killstreak_announce[1] .. " KILL",
		color = packColorData(CheckOptions("exp_color", 14)),
		alpha = 0.9
	})

	make_fine_text(self._exp)
	make_fine_text(self._killstreak_ann)

	local bonus_xp = self._exp_bonus
	local text = self._exp
	local kln = self._killstreak_ann

	local text_base_w = hud.panel:w() / 2 + 20
	local text_base_h = hud.panel:h() / 2 + 20
	local kln_base_w = hud.panel:w() / 2 + text:x() + 20
	local kln_base_h = text_base_h

	text:set_visible(true)
	text:set_center(text_base_w + CheckOptions("exp_adjust_x", 0), text_base_h + CheckOptions("exp_adjust_y", 0))

	if was_special then
		self._bonus_xp_earned = (self._bonus_xp_earned or 0) + ((base_exp * 1.2) - base_exp)
		bonus_xp:set_text("+" .. tostring(round(self._bonus_xp_earned, 1)) .. shrt)
		bonus_xp:set_visible(true)
		make_fine_text(bonus_xp)
	end

	kln:set_visible(CheckOptions("show_announcer"), true)

	self._exp_gained = self._exp_gained + base_exp
	local exp_text = "+" .. tostring(self._exp_gained) .. shrt
	text:set_text(exp_text)
	make_fine_text(text)

	if bonus_xp then bonus_xp:set_center(text:x() + 15, text:y() - 5) end

	kln:set_center(kln_base_w + CheckOptions("kln_adjust_x", 0) + 50, text:y() + 28 +CheckOptions("kln_adjust_y", 0))

	if killstreak >= 2 then
		for i, ann in pairs(killstreak_announce) do
			if killstreak == i + 1 then
				kln:set_text(ann .. " KILL")
				break
			end
		end
	end

	if killstreak > 6 then
		kln:set_text("BLOODTHIRSTY!")
	end

	make_fine_text(kln)

	local function init_exp(o, dir)
		local mt = 0.15
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 0.9)
			local speed = dt * 200

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
		end

		text:remove(o)
		text:hide()
	end

	text:animate(init_exp, -0)

	local function block_anim(set)
		if set == true then
			if self._previous_num < killstreak then
				self._previous_num = killstreak
				self._block_anim = set

				return
			end
		end
		self._block_anim = set
	end

	local function animate_rainbow_color(text)
		local t = 5
		while true do
			local dt = coroutine.yield()
			t = (t + dt) % 5
			local r, g, b = Color.rainbow()
			text:set_color(Color(r, g, b))
		end
	end

	if CheckOptions("exp_color", 14) == 16 then
		self._exp:animate(animate_rainbow_color)
		self._killstreak_ann:animate(animate_rainbow_color)
	end

	if CheckOptions("specialkilled_color", 2) == 16 and was_special then
		bonus_xp:animate(animate_rainbow_color)
	end

	local function init_bonus(o, dir)
		local mt = 0.15
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 0.9)
			local speed = dt * 200

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			block_anim(true)
		end

		bonus_xp:remove(o)
		bonus_xp:hide()
	end

	if was_special then
		bonus_xp:animate(init_bonus, -0)
	end

	local function init_kln(o, dir)
		local mt = 0.25
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 0.9)
			local speed = dt * 200

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			block_anim(true)
		end

		kln:remove(o)
		kln:hide()
	end

	if not self._block_anim or self._previous_num <= 6 then
		kln:animate(init_kln, -0)
	end

	local function func2(o, dir)
		local mt = 1
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 1)
			local speed = dt * 20

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			text:set_alpha(t)
		end

		text:remove(o)
		text:hide()
	end

	local function func_bonus(o, dir)
		local mt = 1
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 1)
			local speed = dt * 20

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			bonus_xp:set_alpha(t)
		end

		bonus_xp:remove(o)
		bonus_xp:hide()
	end

	local function func(o, dir)
		local mt = 4
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 0.9)
			local speed = dt * 20

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			kln:set_alpha(t)
		end

		kln:remove(o)
		kln:hide()
	end

	DelayedCalls:Add("text__anim", EXPOK._data.exp_text_duration, function()
		text:animate(func2, CheckOptions("exp_fade_out_style", 1) - 1)

		if bonus_xp and not self.played_anim_b then
			bonus_xp:animate(func_bonus, CheckOptions("exp_fade_out_style", 1) - 1)
			self:BONUS_PLAYED_ANIM(true)
		end

		if not managers.player:has_active_temporary_property("bonus_xp_special_killed") then
			self._bonus_xp_earned = nil
		end

		self._exp_gained = nil
		managers.player:_killstreak_manage(true)
	end)

	DelayedCalls:Add("kln__anim", EXPOK._data.kln_duration, function()
		kln:animate(func, 1)
		block_anim(false)
		self._bonus_xp_earned = nil
		self._previous_num = nil
	end)
end

function HUDManager:BONUS_PLAYED_ANIM(chk)
	self.played_anim_b = chk
end

function HUDManager:_force_remove_bonus_xp()
	if not self._exp_bonus then
		return
	end

	local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_FULLSCREEN_PD2)
	local child_bonus = hud.panel:child("exp_bonus_text____")
	local bonus_xp = self._exp_bonus
	local function func_bonus(o, dir)
		local mt = 1
		local t = mt

		while t > 0 do
			local dt = coroutine.yield()
			t = math.clamp(t - dt, 0, 1)
			local speed = dt * 20

			o:move(dir * speed, (1 - math.abs(dir)) * -speed)
			bonus_xp:set_alpha(t)
		end

		bonus_xp:remove(o)
		bonus_xp:hide()
	end

	if not child_bonus or not alive(child_bonus) then
		return
	end

	if self.played_anim_b then
		self._bonus_xp_earned = nil
		return
	end

	bonus_xp:animate(func_bonus, CheckOptions("exp_fade_out_style", 1) - 1)
	self._bonus_xp_earned = nil
	self:BONUS_PLAYED_ANIM(true)
end